_Bones_ is the command execution runtime of Bonnie. That means it's responsible for executing commands and managing what happens afterward. _Bones_ is also the name of the micro-language that can be used to specify control flow in Bonnie _ordered commands_. This section of the wiki explains how Bones works and how you can use ordered subcommands to create extremely powerful, automatic, and cross-platform workflows.

This page covers the basics of ordered subcommands, and won't go into the Bones language in depth. For now, just follow along and leave the language itself alone, we'll get to that!

```toml
version = "0.3.2"

[scripts]
test.subcommands.first = "exit 0"
test.subcommands.second = "echo Test && exit 1"
test.order = """
first {
	Success => second
}
"""
```

```
bonnie test	# Test
```

Okay, the above example needs quite a bit of explanation. First off, we've defined a command called `test`, but it doesn't have a root-level command under `.cmd`. Instead, it just has subcommands and a very strange-looking `.order` property. When we execute `bonnie test`, Bones will interpret what we've written in `.order` and it will execute certain subcommands accordingly. We won't go into much depth on that syntax yet, but just understand that it runs `first` and only runs `second` if `first` succeeds. Also note that `first` just exits with the exit code 0 (which means a success), and `second` exits with code 1 (which means a generic failure).

Ordered subcommands are set up the moment the `.order` property is defined, and they impose a number of important syntactic restrictions:

- No top-level `.cmd` property is allowed (that would lead to ambiguity as to if we want to run that or the ordered subcommands themselves)
- All nested subcommands must also define `.order`
- Subcommands can individually interpolate environment variables
- But **any arguments to be interpolated must be defined at the top-level**, these will be passed down to subcommands

That last one is particularly important. We would have to define `test.args`, defining `test.subcommands.first.args` would throw an error because we have `test.order` defined.

The `.order` property itself must be a string, usually a multiline one. In TOML, those are defined with three quotation marks at either end, as in the above example. Inside those is placed a Bones _directive_, which is written in what is basically a miniature scripting language. The next section will explain how this language works!
